-- ************************************
-- VX_sp_ConvertInterviewerNewCase
-- ************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_ConvertInterviewerNewCase]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_ConvertInterviewerNewCase]
GO


CREATE PROCEDURE [dbo].[VX_sp_ConvertInterviewerNewCase]
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @newRespondent varchar(10)
	DECLARE @newResSeed float
	DECLARE @result int
	
	--Get the lock
	EXEC @result =  sp_getapplock 'VX_sp_ConvertInterviewerNewCase','Exclusive'
	
	--Verify the the lock is good   (  @result  >= 0 (success), or < 0 (failure)  )
	IF ( @result < 0   )
	BEGIN
		RAISERROR('VX_sp_ConvertInterviewerNewCase Cannot obtain the lock!!!  sp_getapplock result = %d'  ,16,1 , @result)
		SELECT ''
		RETURN 
	END

	
	BEGIN TRY
		-- Get Last respondent id
		SELECT  @newRespondent = right('0000000000' + CONVERT(VarChar, ( COALESCE(MAX(ResRespondent),0) + 1 )),10) FROM [Respondent] 
		
		-- Get Last ResSeed
		SELECT  @newResSeed= COALESCE(MAX(ResSeed),0) + 1 FROM [Respondent] 
		
				
		INSERT INTO [Respondent] ([ResRespondent],[ResSeed],[modified],[Location]) 
		VALUES (@newRespondent,@newResSeed,GETUTCDATE(),'CAPIClient')

		SELECT @newRespondent
		
		EXEC sp_releaseapplock 'VX_sp_ConvertInterviewerNewCase'
	END TRY
	BEGIN CATCH
		EXEC sp_releaseapplock 'VX_sp_ConvertInterviewerNewCase'
		SELECT ''
	END CATCH;
END



